# 帳票設計書 17-Accessibility Reports

## 概要

本ドキュメントは、GitLabにおけるAccessibility Reports機能の帳票設計書である。ウェブアクセシビリティテスト結果レポートをJSON形式で生成する機能について、出力形式、データ構造、処理フローを定義する。

### 本帳票の処理概要

Accessibility Reportsは、CIパイプラインで実行されたアクセシビリティテストの結果を比較・分析するレポートである。Pa11y、axe-core等のアクセシビリティテストツールの出力を解析し、ベースパイプラインとヘッドパイプラインの結果を比較して、新規エラー、解決済みエラー、既存エラーを分類して表示する。

**業務上の目的・背景**：Webアプリケーションのアクセシビリティ（WCAG準拠など）を継続的に監視する必要がある。このレポートにより、コード変更がアクセシビリティに与える影響を把握し、アクセシビリティの問題を早期に発見・修正することができる。インクルーシブな製品開発を支援する重要な品質指標である。

**帳票の利用シーン**：Merge Requestのレビュー時にアクセシビリティへの影響を確認する場合、アクセシビリティ改善の進捗を追跡する場合、WCAG準拠の監査レポートを作成する場合などで利用される。

**主要な出力内容**：
1. 全体ステータス
2. サマリー（総数、解決数、エラー数）
3. 新規エラー一覧
4. 解決済みエラー一覧
5. 既存エラー一覧
6. 各エラーの詳細（コード、メッセージ、要素セレクタ）

**帳票の出力タイミング**：Merge Request画面のアクセシビリティレポートウィジェットで表示される。パイプライン完了後にデータが生成される。

**帳票の利用者**：開発者、UXデザイナー、アクセシビリティ専門家、QAエンジニア

## 帳票種別

JSON出力（APIレスポンス）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | Merge Request詳細 | `/:namespace/:project/-/merge_requests/:id` | アクセシビリティウィジェット表示 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | JSON |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | N/A（APIレスポンス） |
| 出力方法 | API経由でJSON返却 |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

JSONレスポンス構造

```json
{
  "status": "success/failed",
  "new_errors": [
    {
      "code": "WCAG2AA.Principle1...",
      "type": "error",
      "typeCode": 1,
      "message": "エラーメッセージ",
      "context": "<element>...</element>",
      "selector": "html > body > div"
    }
  ],
  "resolved_errors": [...],
  "existing_errors": [...],
  "summary": {
    "total": 10,
    "resolved": 3,
    "errored": 5
  }
}
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | status | 全体ステータス | 計算値 | 文字列 |

### 明細部（summary）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | total | 総エラー数 | total_count | 数値 |
| 2 | resolved | 解決済みエラー数 | resolved_count | 数値 |
| 3 | errored | 現在のエラー数 | errors_count | 数値 |

### 明細部（エラー配列）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | code | WCAG/ルールコード | accessibility_error.code | 文字列 |
| 2 | type | エラータイプ | accessibility_error.type | 文字列 |
| 3 | typeCode | エラータイプコード | accessibility_error.type_code | 数値 |
| 4 | message | エラーメッセージ | accessibility_error.message | 文字列 |
| 5 | context | 問題のHTML要素 | accessibility_error.context | 文字列 |
| 6 | selector | CSSセレクタ | accessibility_error.selector | 文字列 |

### フッター部

N/A

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| プロジェクトアクセス権 | プロジェクトの読み取り権限 | Yes |
| パイプライン完了 | アクセシビリティレポートアーティファクト生成済み | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | エラーコード | 昇順 |

### 改ページ条件

N/A（JSON出力）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| ci_pipelines | パイプライン情報 | 主テーブル |
| ci_builds | ビルド情報 | pipeline_id = ci_pipelines.id |
| ci_job_artifacts | アクセシビリティレポートアーティファクト | job_id = ci_builds.id |

### テーブル別参照項目詳細

#### ci_job_artifacts

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| file | アクセシビリティレポートファイル | file_type = :accessibility | JSON形式 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| total_count | new_errors + resolved_errors + existing_errors | - | - |
| resolved_count | resolved_errors.count | - | base有り → head無し |
| errors_count | new_errors + existing_errors | - | 現在のエラー数 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[アクセシビリティレポート要求] --> B[base/headパイプライン取得]
    B --> C[アクセシビリティレポート取得]
    C --> D[AccessibilityReportsComparer生成]
    D --> E[AccessibilityReportsComparerSerializer変換]
    E --> F[JSON返却]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| パース中 | レポート解析中 | status: parsing | 再度リクエスト |
| データなし | アクセシビリティレポートなし | 空レスポンス | テストジョブ設定を確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | エラー数に依存（〜数百件） |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | 特になし |

## セキュリティ考慮事項

- プロジェクトのアクセス権限に基づいてレポートを表示
- エラーメッセージにHTMLコンテキストが含まれるため、XSS対策に注意

## 備考

- Pa11y、axe-core等のアクセシビリティテストツールの出力形式に対応
- WCAG 2.0/2.1のガイドラインコードが含まれる

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

アクセシビリティレポートのデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | accessibility_reports_comparer_entity.rb | `app/serializers/accessibility_reports_comparer_entity.rb` | レスポンス構造。status, new_errors, resolved_errors, existing_errors, summaryを公開 |
| 1-2 | accessibility_error_entity.rb | `app/serializers/accessibility_error_entity.rb` | エラー詳細。code, type, message, context, selectorを公開 |

**読解のコツ**: Grape::Entityを使用したシリアライザ。AccessibilityErrorEntityで個別エラーの構造を定義。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | accessibility_reports_comparer_serializer.rb | `app/serializers/accessibility_reports_comparer_serializer.rb` | シリアライザ本体。AccessibilityReportsComparerEntityを使用 |

**主要処理フロー**:
1. **4行目**: entity AccessibilityReportsComparerEntity - エンティティクラスの指定

#### Step 3: パイプラインのアクセシビリティレポート取得を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | pipeline.rb | `app/models/ci/pipeline.rb` | accessibility_reportsメソッドの実装（行1340-1346） |

**主要処理フロー**:
- **1340-1346行目**: accessibility_reportsメソッド - AccessibilityReportsオブジェクトを生成し、各ビルドからレポートを収集

### プログラム呼び出し階層図

```
Pipeline#accessibility_reports
    │
    └─ AccessibilityReports.new
           │
           └─ latest_report_builds(Ci::JobArtifact.of_report_type(:accessibility))
                  │
                  └─ build.collect_accessibility_reports!
                         │
                         └─ AccessibilityReports
                                ├─ new_errors
                                ├─ resolved_errors
                                └─ existing_errors
                                       ↓
                         AccessibilityReportsComparerSerializer
                                       ↓
                         AccessibilityReportsComparerEntity
                                ├─ status
                                ├─ new_errors (using AccessibilityErrorEntity)
                                ├─ resolved_errors
                                ├─ existing_errors
                                └─ summary
                                       ↓
                                JSON レスポンス
```

### データフロー図

```
[入力]                      [処理]                         [出力]

ci_job_artifacts ─────────▶ Pipeline#accessibility_reports ──▶ AccessibilityReports
(JSON形式)                     │                                      │
                               └─ collect_accessibility_reports!      │
                                                                      ↓
                                                         AccessibilityReportsComparer
base_pipeline ──────────────────────────────────────▶        │
                                                             ├─ new_errors
head_pipeline ──────────────────────────────────────▶        ├─ resolved_errors
                                                             └─ existing_errors
                                                                      ↓
                                                  AccessibilityReportsComparerSerializer
                                                                      ↓
                                                               JSON レスポンス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| accessibility_reports_comparer_serializer.rb | `app/serializers/accessibility_reports_comparer_serializer.rb` | ソース | シリアライザ |
| accessibility_reports_comparer_entity.rb | `app/serializers/accessibility_reports_comparer_entity.rb` | ソース | エンティティ |
| accessibility_error_entity.rb | `app/serializers/accessibility_error_entity.rb` | ソース | エラーエンティティ |
| pipeline.rb | `app/models/ci/pipeline.rb` | ソース | accessibility_reportsメソッド |
| accessibility_reports.rb | `lib/gitlab/ci/reports/accessibility_reports.rb` | ソース | レポートモデル |
| accessibility_reports_comparer.rb | `lib/gitlab/ci/reports/accessibility_reports_comparer.rb` | ソース | 比較ロジック |
